#pragma once

#include <afx.h>
#include "ConfigSPC.h"
#include "CharSetString.h"

#define kMaxOpenedLines				5

enum ELineState 
{
	eActive = 0, 
	eHeld,
	eDialing,
	eAlerting,
	eIncoming,
	eWaiting,
	//Ych
	eDisconnected
};
/////////////////////////////////////////////////////////////////////////////
enum ESpcOperation
{
	eConnect,
	eBusy,
	eRelease,
	eDialToAlert,
	eError,
	eAccept,
	eReject,
	eLastOperation
};
/////////////////////////////////////////////////////////////////////////////
enum ESpcType
{
	eIncomingCall,
	eOutgoingCall
};
#define kMaxPhoneNumberLength	30
#include "Service.h"
////////////////////////////////////////////////////////////////////////////////
#ifdef DLLMANAGER_EXPORTS
	#define DLLMANAGER_API __declspec(dllexport)
#else
	#define DLLMANAGER_API __declspec(dllimport) 
#endif
////////////////////////////////////////////////////////////////////////////////
class DLLMANAGER_API CSpeechCall : public CObject
{
protected:	
	CConfigSPC* mConfigSPC;
public :
	ELineState		mState;
	bool			mMultiParty;
	int				mLineId;
	char			mOtherPartyNumber[kMaxPhoneNumberLength + 1];
	CCharSetString	mOtherPartyName;
	CCharSetString	mOtherPartyNameConverted;
//	CString	mOtherPartyName;
//	CString	mOtherPartyNameConverted;
	int			startTime;
public:
	CSpeechCall(void);
	CSpeechCall(CString iNumber, CString iName, int iLineID, CConfigSPC* icfgSPC);
	virtual ~CSpeechCall(void);

	bool		GetOperationPossible(ESpcOperation ePoss) {return PossibleOperations[ePoss];};
	int			GetLineId() {return mLineId;}
	ELineState	GetLineState() {return mState;}
	virtual		void SetLineState(ELineState iState, BOOL iForceNotif=FALSE);
	virtual		ESpcType GetType()=0;
	CString		GetOtherPartyNumber(){return mOtherPartyNumber;}
	CString		GetOtherPartyName();
	bool		IsMultiParty(){return mMultiParty;}
	void		SetMultiParty(bool iMultiParty) {mMultiParty=iMultiParty;}

	bool PossibleOperations[eLastOperation];
	void DisableAllOpps();

	static char mTypeString[20];

	virtual bool IsCallerIdAvailable(){return false;}
	virtual bool AcceptCall();
	virtual bool Connect(){return false;}
	virtual bool Busy(){return false;}
	virtual bool Error(){return false;}
	virtual bool CloseLine();
	virtual bool HoldLine();
	virtual bool Release();
	// Set the line to eDisconnected (so it can be overwritten)
	virtual bool HangCall();
	virtual bool DialToAlert(){return false;}
	virtual bool WaitingToIncoming(){return false;}
	// Send ChangeCall notif
	virtual void SendChangeCallNotif() {return;};
};
